<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class UserProfile extends Model 
{

    protected $table = 'user_profile';
    public $timestamps = false;
    protected $fillable = array('name', 'country_id', 'city_id', 'about');

    public function avatars()
    {
        return $this->hasMany('App\Models\UserAvatar');
    }

    public function city()
    {
        return $this->hasOne('App\Models\City');
    }

    public function country()
    {
        return $this->hasOne('App\Models\Country');
    }

}